/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.scouter.netherdepthsupgrade.entity.NDUEntity;
import com.scouter.netherdepthsupgrade.items.LavaFishingRodItem;
import com.scouter.netherdepthsupgrade.loot.NDULootTables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class LavaFishingBobberEntity
extends FishingHook
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.m_135353_(LavaFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.m_135353_(LavaFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final Random syncronizedRandom = new Random();
    private boolean bitingFish;
    private final int luck;
    private final int lureSpeed;
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private int outOfLavaTime;
    private float fishAngle;
    private boolean openLava = true;
    @Nullable
    private Entity hookedEntity;
    private LavaFishingBobberEntityState currentState = LavaFishingBobberEntityState.FLYING;

    public LavaFishingBobberEntity(PlayMessages.SpawnEntity spawnPacket, Level level) {
        super(level.m_46003_(spawnPacket.getAdditionalData().m_130259_()), level, 0, 0);
        this.luck = 0;
        this.lureSpeed = 0;
    }

    public LavaFishingBobberEntity(Player p_37106_, Level level, int luck, int lureSpeed) {
        super(p_37106_, level, luck, lureSpeed);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_HOOKED_ENTITY, (Object)0);
        this.m_20088_().m_135372_(DATA_BITING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_HOOKED_ENTITY.equals(pKey)) {
            int i = (Integer)this.m_20088_().m_135370_(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedEntity = i > 0 ? this.f_19853_.m_6815_(i - 1) : null;
        }
        if (DATA_BITING.equals(pKey)) {
            this.bitingFish = (Boolean)this.m_20088_().m_135370_(DATA_BITING);
            if (this.bitingFish) {
                this.m_20334_(this.m_20184_().f_82479_, -0.4f * Mth.m_216267_((RandomSource)this.f_19796_, (float)0.6f, (float)1.0f), this.m_20184_().f_82481_);
            }
        }
        super.m_7350_(pKey);
    }

    private boolean shouldStopFishing(Player player) {
        ItemStack itemstack = player.m_21205_();
        ItemStack itemstack1 = player.m_21206_();
        boolean flag = itemstack.m_41720_() instanceof LavaFishingRodItem;
        boolean flag1 = itemstack1.m_41720_() instanceof LavaFishingRodItem;
        if (!player.m_213877_() && player.m_6084_() && (flag || flag1) && !(this.m_20280_((Entity)player) > 1024.0)) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    public void m_8119_() {
        this.syncronizedRandom.setSeed(this.m_20148_().getLeastSignificantBits() ^ this.f_19853_.m_46467_());
        this.canUpdate();
        Player player = this.m_37168_();
        if (player == null) {
            this.m_146870_();
        } else if (this.f_19853_.f_46443_ || !this.shouldStopFishing(player)) {
            boolean flag;
            if (this.f_19861_) {
                ++this.life;
                if (this.life >= 1200) {
                    this.m_146870_();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.m_20183_();
            FluidState fluidstate = this.f_19853_.m_6425_(blockpos);
            if (fluidstate.m_205070_(FluidTags.f_13132_)) {
                f = fluidstate.m_76155_((BlockGetter)this.f_19853_, blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == LavaFishingBobberEntityState.FLYING) {
                if (this.hookedEntity != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.currentState = LavaFishingBobberEntityState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.currentState = LavaFishingBobberEntityState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == LavaFishingBobberEntityState.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.m_213877_() && this.hookedEntity.f_19853_.m_46472_() == this.f_19853_.m_46472_()) {
                            this.m_6034_(this.hookedEntity.m_20185_(), this.hookedEntity.m_20227_(0.8), this.hookedEntity.m_20189_());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = LavaFishingBobberEntityState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == LavaFishingBobberEntityState.BOBBING) {
                    Vec3 vec3 = this.m_20184_();
                    double d0 = this.m_20186_() + vec3.f_82480_ - (double)blockpos.m_123342_() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.m_20334_(vec3.f_82479_ * 0.9, vec3.f_82480_ - d0 * (double)this.f_19796_.m_188501_() * 0.2, vec3.f_82481_ * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openLava = true;
                    } else {
                        boolean bl2 = this.openLava = this.openLava && this.outOfLavaTime < 10 && this.calculateOpenLava(blockpos);
                    }
                    if (flag) {
                        this.outOfLavaTime = Math.max(0, this.outOfLavaTime - 1);
                        if (this.bitingFish) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.f_19853_.f_46443_) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfLavaTime = Math.min(10, this.outOfLavaTime + 1);
                    }
                }
            }
            if (!fluidstate.m_205070_(FluidTags.f_13132_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_37283_();
            if (this.currentState == LavaFishingBobberEntityState.FLYING && (this.f_19861_ || this.f_19862_)) {
                this.m_20256_(Vec3.f_82478_);
            }
            double d1 = 0.92;
            this.m_20256_(this.m_20184_().m_82490_(0.92));
            this.m_20090_();
        }
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
        if (hitresult.m_6662_() == HitResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    protected boolean m_5603_(Entity p_37135_) {
        return super.m_5603_(p_37135_) || p_37135_.m_6084_() && p_37135_ instanceof ItemEntity;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_) {
            this.setHookedEntity(pResult.m_82443_());
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_20256_(this.m_20184_().m_82541_().m_82490_(pResult.m_82448_((Entity)this)));
    }

    private boolean calculateOpenLava(BlockPos p_37159_) {
        FishLavaType fishinghook$fishlavatype = FishLavaType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            FishLavaType fishinghook$fishlavatype1 = this.getOpenLavaTypeForArea(p_37159_.m_7918_(-2, i, -2), p_37159_.m_7918_(2, i, 2));
            switch (fishinghook$fishlavatype1) {
                case INVALID: {
                    return false;
                }
                case ABOVE_LAVA: {
                    if (fishinghook$fishlavatype != FishLavaType.INVALID) break;
                    return false;
                }
                case INSIDE_LAVA: {
                    if (fishinghook$fishlavatype != FishLavaType.ABOVE_LAVA) break;
                    return false;
                }
            }
            fishinghook$fishlavatype = fishinghook$fishlavatype1;
        }
        return true;
    }

    private FishLavaType getOpenLavaTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.m_121990_((BlockPos)p_37148_, (BlockPos)p_37149_).map(this::getOpenLavaTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : FishLavaType.INVALID).orElse(FishLavaType.INVALID);
    }

    private FishLavaType getOpenLavaTypeForBlock(BlockPos p_37164_) {
        BlockState blockstate = this.f_19853_.m_8055_(p_37164_);
        if (!blockstate.m_60795_()) {
            FluidState fluidstate = blockstate.m_60819_();
            return fluidstate.m_205070_(FluidTags.f_13132_) && fluidstate.m_76170_() && blockstate.m_60812_((BlockGetter)this.f_19853_, p_37164_).m_83281_() ? FishLavaType.INSIDE_LAVA : FishLavaType.INVALID;
        }
        return FishLavaType.ABOVE_LAVA;
    }

    private void catchingFish(BlockPos p_37146_) {
        ServerLevel serverlevel = (ServerLevel)this.f_19853_;
        int i = 1;
        BlockPos blockpos = p_37146_.m_7494_();
        if (this.f_19796_.m_188501_() < 0.25f && this.f_19853_.m_46758_(blockpos)) {
            ++i;
        }
        if (this.f_19796_.m_188501_() < 0.5f && !this.f_19853_.m_45527_(blockpos)) {
            --i;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.m_20088_().m_135381_(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)(this.f_19796_.m_188583_() * 4.0);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f);
                float f2 = Mth.m_14089_((float)f);
                double d0 = this.m_20185_() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                double d1 = (float)Mth.m_14107_((double)this.m_20186_()) + 1.0f;
                double d2 = this.m_20189_() + (double)(f2 * (float)this.timeUntilHooked * 0.1f);
                BlockState blockstate = serverlevel.m_8055_(new BlockPos(d0, d1 - 1.0, d2));
                if (serverlevel.m_8055_(new BlockPos((int)d0, (int)d1 - 1, (int)d2)).m_60767_() == Material.f_76307_) {
                    if (this.f_19796_.m_188501_() < 0.15f) {
                        serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                double d3 = this.m_20186_() + 0.5;
                serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                this.nibble = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40);
                this.m_20088_().m_135381_(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.f_19796_.m_188501_() < f5) {
                float f6 = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.m_216267_((RandomSource)this.f_19796_, (float)25.0f, (float)60.0f);
                double d4 = this.m_20185_() + (double)(Mth.m_14031_((float)f6) * f7) * 0.1;
                double d5 = (float)Mth.m_14107_((double)this.m_20186_()) + 1.0f;
                double d6 = this.m_20189_() + (double)(Mth.m_14089_((float)f6) * f7) * 0.1;
                BlockState blockstate1 = serverlevel.m_8055_(new BlockPos(d4, d5 - 1.0, d6));
                if (serverlevel.m_8055_(new BlockPos(d4, d5 - 1.0, d6)).m_60767_() == Material.f_76307_) {
                    serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123802_, d4, d5, d6, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
        }
    }

    public int m_37156_(ItemStack p_37157_) {
        Player player = this.m_37168_();
        if (!this.f_19853_.f_46443_ && player != null && !this.shouldStopFishing(player)) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.hookedEntity != null) {
                this.m_150155_(this.hookedEntity);
                CriteriaTriggers.f_10553_.m_40416_((ServerPlayer)player, p_37157_, (FishingHook)this, Collections.emptyList());
                this.f_19853_.m_7605_((Entity)this, (byte)31);
                i = this.hookedEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)p_37157_).m_78972_(LootContextParams.f_81455_, (Object)this).m_230911_(this.f_19796_).m_78963_((float)this.luck + player.m_36336_());
                lootcontext$builder.m_78972_(LootContextParams.f_81458_, (Object)this.m_37282_()).m_78972_(LootContextParams.f_81455_, (Object)this);
                LootTable loottable = null;
                double d = (float)Math.floor(this.m_20191_().f_82289_) + 1.0f;
                BlockState blockstate = this.f_19853_.m_8055_(new BlockPos(this.m_20182_().f_82479_, d - 1.0, this.m_20182_().f_82481_));
                loottable = blockstate.m_60713_(Blocks.f_49991_) ? (this.f_19853_.m_46472_() == Level.f_46429_ ? Objects.requireNonNull(this.f_19853_.m_7654_()).m_129898_().m_79217_(NDULootTables.NETHER_FISHING) : Objects.requireNonNull(this.f_19853_.m_7654_()).m_129898_().m_79217_(NDULootTables.LAVA_FISHING)) : Objects.requireNonNull(this.f_19853_.m_7654_()).m_129898_().m_79217_(NDULootTables.FAILED_FISHING);
                if (loottable == null && event != null) {
                    this.m_146870_();
                    return 0;
                }
                ObjectArrayList list = loottable.m_230922_(lootcontext$builder.m_78975_(LootContextParamSets.f_81414_));
                event = new ItemFishedEvent((List)list, this.f_19861_ ? 2 : 1, (FishingHook)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.m_146870_();
                    return event.getRodDamage();
                }
                CriteriaTriggers.f_10553_.m_40416_((ServerPlayer)player, p_37157_, (FishingHook)this, (Collection)list);
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), itemstack);
                    double d0 = player.m_20185_() - this.m_20185_();
                    double d1 = player.m_20186_() - (this.m_20186_() + 1.0);
                    double d2 = player.m_20189_() - this.m_20189_();
                    double d3 = 0.1;
                    itementity.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.f_19853_.m_7967_((Entity)itementity);
                    player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, this.f_19796_.m_188503_(6) + 1));
                    if (!itemstack.m_204117_(ItemTags.f_13156_)) continue;
                    player.m_36222_(Stats.f_12939_, 1);
                }
                i = 1;
            }
            if (this.f_19861_) {
                i = 2;
            }
            this.m_146870_();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    public void m_142036_() {
        this.updateOwnerInfo(null);
    }

    public void m_5602_(@Nullable Entity pEntity) {
        super.m_5602_(pEntity);
        this.updateOwnerInfo(this);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
    }

    public boolean m_6783_(double pDistance) {
        double d0 = 64.0;
        return pDistance < 4096.0;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.updateOwnerInfo(null);
        super.m_142687_(pReason);
    }

    private void updateOwnerInfo(@Nullable LavaFishingBobberEntity p_150148_) {
        Player player = this.m_37168_();
        if (player != null) {
            player.f_36083_ = p_150148_;
        }
    }

    private void setHookedEntity(@Nullable Entity entity) {
        this.hookedEntity = entity;
        this.m_20088_().m_135381_(DATA_HOOKED_ENTITY, (Object)(entity == null ? 0 : entity.m_19879_() + 1));
    }

    @Nonnull
    public EntityType<?> m_6095_() {
        return (EntityType)NDUEntity.LAVA_BOBBER.get();
    }

    protected void m_150155_(Entity entityPulled) {
        Entity entity = this.m_37282_();
        if (entity != null) {
            Vec3 vec3 = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20186_() - this.m_20186_(), entity.m_20189_() - this.m_20189_()).m_82490_(0.1);
            entityPulled.m_20256_(entityPulled.m_20184_().m_82549_(vec3));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Player player = this.m_37168_();
        if (player != null) {
            buffer.m_130077_(player.m_20148_());
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    static enum LavaFishingBobberEntityState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum FishLavaType {
        ABOVE_LAVA,
        INSIDE_LAVA,
        INVALID;

    }
}

